% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{easter}
\alias{easter}
\alias{easter.um}
\title{Easter effect}
\usage{
easter(um, ...)

\method{easter}{um}(um, z = NULL, n.ahead = 0, ...)
}
\arguments{
\item{um}{an object of class \code{\link{um}}.}

\item{...}{additional arguments.}

\item{z}{a time series.}

\item{n.ahead}{a positive integer to extend the sample period of the
Easter regression variable with \code{n.ahead} observations, which could be
necessary to forecast the output.}
}
\value{
An object of class "\code{\link{tfm}}".
}
\description{
\code{easter} extends the ARIMA model \code{um} by including a regression
variable to capture the Easter effect.
}
\examples{
Y <- rsales
um1 <- um(Y, i = list(1, c(1, 12)), ma = list(1, c(1, 12)), bc = TRUE)
tfm1 <- easter(um1)
}
