% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_group_by_window}
\alias{dataset_group_by_window}
\title{Group windows of elements by key and reduce them}
\usage{
dataset_group_by_window(
  dataset,
  key_func,
  reduce_func,
  window_size = NULL,
  window_size_func = NULL,
  name = NULL
)
}
\arguments{
\item{dataset}{a TF Dataset}

\item{key_func}{A function mapping a nested structure of tensors (having
shapes and types defined by \code{self$output_shapes} and \code{self$output_types})
to a scalar \code{tf.int64} tensor.}

\item{reduce_func}{A function mapping a key and a dataset of up to
\code{window_size} consecutive elements matching that key to another dataset.}

\item{window_size}{A \code{tf.int64} scalar \code{tf.Tensor}, representing the number
of consecutive elements matching the same key to combine in a single batch,
which will be passed to \code{reduce_func}. Mutually exclusive with
\code{window_size_func}.}

\item{window_size_func}{A function mapping a key to a \code{tf.int64} scalar
\code{tf.Tensor}, representing the number of consecutive elements matching the
same key to combine in a single batch, which will be passed to
\code{reduce_func}. Mutually exclusive with \code{window_size}.}

\item{name}{(Optional.) A name for the Tensorflow operation.}
}
\description{
Group windows of elements by key and reduce them
}
\details{
This transformation maps each consecutive element in a dataset to a
key using \code{key_func()} and groups the elements by key. It then applies
\code{reduce_func()} to at most \code{window_size_func(key)} elements matching the same
key. All except the final window for each key will contain
\code{window_size_func(key)} elements; the final window may be smaller.

You may provide either a constant \code{window_size} or a window size determined
by the key through \code{window_size_func}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{window_size <-  5
dataset <- range_dataset(to = 10) \%>\%
  dataset_group_by_window(
    key_func = function(x) x \%\% 2,
    reduce_func = function(key, ds) dataset_batch(ds, window_size),
    window_size = window_size
  )

it <- as_array_iterator(dataset)
while (!is.null(elem <- iter_next(it)))
  print(elem)
#> tf.Tensor([0 2 4 6 8], shape=(5), dtype=int64)
#> tf.Tensor([1 3 5 7 9], shape=(5), dtype=int64)
}\if{html}{\out{</div>}}
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/data/Dataset#group_by_window}
}
}
