% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{fit.FeatureSpec}
\alias{fit.FeatureSpec}
\title{Fits a feature specification.}
\usage{
\method{fit}{FeatureSpec}(object, dataset = NULL, ...)
}
\arguments{
\item{object}{A feature specification created with \code{\link[=feature_spec]{feature_spec()}}.}

\item{dataset}{(Optional) A TensorFlow dataset. If \code{NULL} it will use
the dataset provided when initilializing the \code{feature_spec}.}

\item{...}{(unused)}
}
\value{
a fitted \code{FeatureSpec} object.
}
\description{
This function will \code{fit} the specification. Depending
on the steps added to the specification it will compute
for example, the levels of categorical features, normalization
constants, etc.
}
\examples{
\dontrun{
library(tfdatasets)
data(hearts)
hearts <- tensor_slices_dataset(hearts) \%>\% dataset_batch(32)

# use the formula interface
spec <- feature_spec(hearts, target ~ age) \%>\%
  step_numeric_column(age)

spec_fit <- fit(spec)
spec_fit
}
}
\seealso{
\itemize{
\item \code{\link[=feature_spec]{feature_spec()}} to initialize the feature specification.
\item \code{\link[=dataset_use_spec]{dataset_use_spec()}} to create a tensorflow dataset prepared to modeling.
\item \link{steps} to a list of all implemented steps.
}

Other Feature Spec Functions: 
\code{\link{dataset_use_spec}()},
\code{\link{feature_spec}()},
\code{\link{step_bucketized_column}()},
\code{\link{step_categorical_column_with_hash_bucket}()},
\code{\link{step_categorical_column_with_identity}()},
\code{\link{step_categorical_column_with_vocabulary_file}()},
\code{\link{step_categorical_column_with_vocabulary_list}()},
\code{\link{step_crossed_column}()},
\code{\link{step_embedding_column}()},
\code{\link{step_indicator_column}()},
\code{\link{step_numeric_column}()},
\code{\link{step_remove_column}()},
\code{\link{step_shared_embeddings_column}()},
\code{\link{steps}}
}
\concept{Feature Spec Functions}
