% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_categorical_with_identity}
\alias{column_categorical_with_identity}
\title{Construct a Categorical Column that Returns Identity Values}
\usage{
column_categorical_with_identity(..., num_buckets, default_value = NULL)
}
\arguments{
\item{...}{Expression(s) identifying input feature(s). Used as the column
name and the dictionary key for feature parsing configs, feature tensors,
and feature columns.}

\item{num_buckets}{Number of unique values.}

\item{default_value}{If \code{NULL}, this column's graph operations will fail for
out-of-range inputs. Otherwise, this value must be in the range \code{[0, num_buckets)}, and will replace inputs in that range.}
}
\value{
A categorical column that returns identity values.
}
\description{
Use this when your inputs are integers in the range \code{[0, num_buckets)}, and
you want to use the input value itself as the categorical ID. Values outside
this range will result in \code{default_value} if specified, otherwise it will
fail.
}
\details{
Typically, this is used for contiguous ranges of integer indexes, but it
doesn't have to be. This might be inefficient, however, if many of IDs are
unused. Consider \code{categorical_column_with_hash_bucket} in that case.

For input dictionary \code{features}, \code{features$key} is either tensor or sparse
tensor object. If it's tensor object, missing values can be represented by \code{-1} for
int and \code{''} for string. Note that these values are independent of the
\code{default_value} argument.
}
\section{Raises}{

\itemize{
\item ValueError: if \code{num_buckets} is less than one.
\item ValueError: if \code{default_value} is not in range \code{[0, num_buckets)}.
}
}

\seealso{
Other feature column constructors: \code{\link{column_bucketized}},
  \code{\link{column_categorical_weighted}},
  \code{\link{column_categorical_with_hash_bucket}},
  \code{\link{column_categorical_with_vocabulary_file}},
  \code{\link{column_categorical_with_vocabulary_list}},
  \code{\link{column_crossed}},
  \code{\link{column_embedding}},
  \code{\link{column_numeric}}, \code{\link{input_layer}}
}
\concept{feature column constructors}
