% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_categorical_with_hash_bucket}
\alias{column_categorical_with_hash_bucket}
\title{Represents Sparse Feature where IDs are set by Hashing}
\usage{
column_categorical_with_hash_bucket(..., hash_bucket_size,
  dtype = tf$string)
}
\arguments{
\item{...}{Expression(s) identifying input feature(s). Used as the column
name and the dictionary key for feature parsing configs, feature tensors,
and feature columns.}

\item{hash_bucket_size}{An int > 1. The number of buckets.}

\item{dtype}{The type of features. Only string and integer types are
supported.}
}
\value{
A \code{_HashedCategoricalColumn}.
}
\description{
Use this when your sparse features are in string or integer format, and you
want to distribute your inputs into a finite number of buckets by hashing.
output_id = Hash(input_feature_string) % bucket_size For input dictionary
\code{features}, \code{features$key$} is either tensor or sparse tensor object. If it's
tensor object, missing values can be represented by \code{-1} for int and \code{''} for
string. Note that these values are independent of the \code{default_value}
argument.
}
\section{Raises}{

\itemize{
\item ValueError: \code{hash_bucket_size} is not greater than 1.
\item ValueError: \code{dtype} is neither string nor integer.
}
}

\seealso{
Other feature column constructors: \code{\link{column_bucketized}},
  \code{\link{column_categorical_weighted}},
  \code{\link{column_categorical_with_identity}},
  \code{\link{column_categorical_with_vocabulary_file}},
  \code{\link{column_categorical_with_vocabulary_list}},
  \code{\link{column_crossed}},
  \code{\link{column_embedding}},
  \code{\link{column_numeric}}, \code{\link{input_layer}}
}
\concept{feature column constructors}
