% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_vector_sinh_arcsinh_diag}
\alias{tfd_vector_sinh_arcsinh_diag}
\title{The (diagonal) SinhArcsinh transformation of a distribution on \code{R^k}}
\usage{
tfd_vector_sinh_arcsinh_diag(
  loc = NULL,
  scale_diag = NULL,
  scale_identity_multiplier = NULL,
  skewness = NULL,
  tailweight = NULL,
  distribution = NULL,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = "VectorSinhArcsinhDiag"
)
}
\arguments{
\item{loc}{Floating-point Tensor. If this is set to NULL, loc is
implicitly 0. When specified, may have shape \verb{[B1, ..., Bb, k]} where
b >= 0 and k is the event size.}

\item{scale_diag}{Non-zero, floating-point Tensor representing a diagonal
matrix added to scale. May have shape \verb{[B1, ..., Bb, k]}, b >= 0,
and characterizes b-batches of k x k diagonal matrices added to
scale. When both scale_identity_multiplier and scale_diag are
NULL then scale is the Identity.}

\item{scale_identity_multiplier}{Non-zero, floating-point Tensor representing
a scale-identity-matrix added to scale. May have shape
\verb{[B1, ..., Bb]}, b >= 0, and characterizes b-batches of scale
k x k identity matrices added to scale. When both
scale_identity_multiplier and scale_diag are NULL then scale
is the Identity.}

\item{skewness}{Skewness parameter.  floating-point Tensor with shape
broadcastable with event_shape.}

\item{tailweight}{Tailweight parameter.  floating-point Tensor with shape
broadcastable with event_shape.}

\item{distribution}{\code{tf$distributions$Distribution}-like instance. Distribution from which k
iid samples are used as input to transformation F.  Default is
tfd_normal(loc = 0, scale = 1).
Must be a scalar-batch, scalar-event distribution.  Typically
distribution$reparameterization_type = FULLY_REPARAMETERIZED or it is
a function of non-trainable parameters. WARNING: If you backprop through
a VectorSinhArcsinhDiag sample and distribution is not
FULLY_REPARAMETERIZED yet is a function of trainable variables, then
the gradient will be incorrect!}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
This distribution models a random vector \verb{Y = (Y1,...,Yk)}, making use of
a SinhArcsinh transformation (which has adjustable tailweight and skew),
a rescaling, and a shift.
The SinhArcsinh transformation of the Normal is described in great depth in
\href{https://oro.open.ac.uk/22510/}{Sinh-arcsinh distributions}.
Here we use a slightly different parameterization, in terms of tailweight
and skewness.  Additionally we allow for distributions other than Normal,
and control over scale as well as a "shift" parameter loc.
}
\details{
Mathematical Details

Given iid random vector \verb{Z = (Z1,...,Zk)}, we define the VectorSinhArcsinhDiag
transformation of \code{Z}, \code{Y}, parameterized by
\verb{(loc, scale, skewness, tailweight)}, via the relation (with \code{@} denoting matrix multiplication):\preformatted{Y := loc + scale @ F(Z) * (2 / F_0(2))
F(Z) := Sinh( (Arcsinh(Z) + skewness) * tailweight )
F_0(Z) := Sinh( Arcsinh(Z) * tailweight )
}

This distribution is similar to the location-scale transformation
\code{L(Z) := loc + scale @ Z} in the following ways:
\itemize{
\item If \code{skewness = 0} and \code{tailweight = 1} (the defaults), \code{F(Z) = Z}, and then
\code{Y = L(Z)} exactly.
\item \code{loc} is used in both to shift the result by a constant factor.
\item The multiplication of \code{scale} by \code{2 / F_0(2)} ensures that if \code{skewness = 0}
\code{P[Y - loc <= 2 * scale] = P[L(Z) - loc <= 2 * scale]}.
Thus it can be said that the weights in the tails of \code{Y} and \code{L(Z)} beyond
\code{loc + 2 * scale} are the same.
This distribution is different than \code{loc + scale @ Z} due to the
reshaping done by \code{F}:
\itemize{
\item Positive (negative) \code{skewness} leads to positive (negative) skew.
\item positive skew means, the mode of \code{F(Z)} is "tilted" to the right.
\item positive skew means positive values of \code{F(Z)} become more likely, and
negative values become less likely.
\item Larger (smaller) \code{tailweight} leads to fatter (thinner) tails.
\item Fatter tails mean larger values of \verb{|F(Z)|} become more likely.
\item \code{tailweight < 1} leads to a distribution that is "flat" around \code{Y = loc},
and a very steep drop-off in the tails.
\item \code{tailweight > 1} leads to a distribution more peaked at the mode with
heavier tails.
To see the argument about the tails, note that for \verb{|Z| >> 1} and
\verb{|Z| >> (|skewness| * tailweight)**tailweight}, we have
\verb{Y approx 0.5 Z**tailweight e**(sign(Z) skewness * tailweight)}.
To see the argument regarding multiplying \code{scale} by \code{2 / F_0(2)},
}\preformatted{P[(Y - loc) / scale <= 2] = P[F(Z) * (2 / F_0(2)) <= 2]
= P[F(Z) <= F_0(2)]
= P[Z <= 2]  (if F = F_0).
}
}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
