% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate normal data for kmeans tests}
\usage{
simulate_data(
  n = 100,
  sd = 0.3,
  nclust = 30,
  dims = 2,
  frac_na = NULL,
  add_true_clust = TRUE,
  id_column = TRUE
)
}
\arguments{
\item{n}{number of observations per cluster}

\item{sd}{sd}

\item{nclust}{number of clusters}

\item{dims}{number of dimensions}

\item{frac_na}{fraction of NA in the first dimension}

\item{add_true_clust}{add a column with the true cluster ids}

\item{id_column}{add a column with the id}
}
\value{
simulated data
}
\description{
Creates \code{nclust} clusters normally distributed around \code{1:nclust}
}
\examples{
simulate_data(n = 100, sd = 0.3, nclust = 5, dims = 2)

# add 20\% missing data
simulate_data(n = 100, sd = 0.3, nclust = 5, dims = 2, frac_na = 0.2)

}
