% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_matrix.R
\name{as_matrix}
\alias{as_matrix}
\title{Convert sparse matrix into dense matrix}
\usage{
as_matrix(x, parallel = FALSE, sparse = FALSE)
}
\arguments{
\item{x}{A matrix.}

\item{parallel}{Logical value, default is \emph{\code{FALSE}}.
Setting to parallelize the computation with \link[RcppParallel:setThreadOptions]{RcppParallel::setThreadOptions}.}

\item{sparse}{Logical value, default is \emph{\code{FALSE}}, whether to output a sparse matrix.}
}
\value{
A dense or sparse matrix
}
\description{
Convert sparse matrix into dense matrix
}
\examples{
m <- simulate_sparse_matrix(
  1000, 1000,
  decimal = 3
)

system.time(
  a <- as.matrix(m)
)
system.time(
  b <- as_matrix(m)
)
system.time(
  c <- as_matrix(m, parallel = TRUE)
)
system.time(
  d <- as_matrix(m, sparse = TRUE)
)

m[1:5, 1:5]
a[1:5, 1:5]
b[1:5, 1:5]
c[1:5, 1:5]

identical(a, b)
identical(a, c)
identical(b, c)
identical(a, d)
identical(b, d)
}
