% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_message.R
\name{log_message}
\alias{log_message}
\title{Print diagnostic message}
\usage{
log_message(
  ...,
  verbose = TRUE,
  message_type = c("info", "success", "warning", "error"),
  cli_model = TRUE,
  timestamp = TRUE,
  timestamp_format = "\%Y-\%m-\%d \%H:\%M:\%S",
  level = 1,
  symbol = "  ",
  text_color = NULL,
  back_color = NULL,
  multiline_indent = TRUE,
  .envir = parent.frame(),
  .frame = .envir
)
}
\arguments{
\item{...}{Text to print.}

\item{verbose}{Logical value, default is \emph{\code{TRUE}}.
Whether to print the message.}

\item{message_type}{Type of message, default is \emph{\code{info}}.
Could be choose one of \emph{\code{info}}, \emph{\code{success}}, \emph{\code{warning}}, and \emph{\code{error}}.}

\item{cli_model}{Logical value, default is \emph{\code{TRUE}}.
Whether to use the \code{cli} package to print the message.}

\item{timestamp}{Logical value, default is \emph{\code{TRUE}}.
Whether to show the current time in the message.}

\item{timestamp_format}{Character value, default is \emph{\code{"\%Y-\%m-\%d \%H:\%M:\%S"}}.
Format string for timestamp display.}

\item{level}{Integer value, default is \emph{\code{1}}.
The level of the message, which affects the indentation.
Level 1 has no indentation, higher levels add more indentation.}

\item{symbol}{Character value, default is \emph{\code{"  "}} (two spaces).
The symbol used for indentation.
When specified, it ignores the level parameter and uses the symbol directly.}

\item{text_color}{Character value, default is \emph{\code{NULL}}.
Color for the message text.
Available colors: "red", "green", "blue", "yellow", "magenta", "cyan", "white", "black".}

\item{back_color}{Character value, default is \emph{\code{NULL}}.
Background color for the message text.
Available colors: "red", "green", "blue", "yellow", "magenta", "cyan", "white", "black".}

\item{multiline_indent}{Logical value, default is \emph{\code{TRUE}}.
Whether to apply consistent formatting (timestamp and indentation) to each line in multiline messages.
When TRUE, each line gets the full formatting; when FALSE, only the first line gets the timestamp.}

\item{.envir}{The environment to evaluate calls in. Default is \emph{\code{parent.frame()}}.}

\item{.frame}{The frame to use for error reporting. Default is \emph{\code{.envir}}.}
}
\value{
\code{Formated message} printed to the console.
}
\description{
Integrate the message printing function with the \code{cli} package,
and the \link[base:message]{base::message} function.
The message could be suppressed by \link[base:message]{base::suppressMessages}.
}
\examples{
# basic usage
log_message("Hello, ", "world!")
log_message("hello, world!")
log_message("Hello, world!", timestamp = FALSE)
log_message("Hello, ", "world!", message_type = "success")
log_message("Hello, world!", message_type = "warning")
log_message("Hello, ", "world!", cli_model = FALSE)

# suppress messages
suppressMessages(log_message("Hello, world!"))
log_message("Hello, world!", verbose = FALSE)
options(log_message.verbose = FALSE)
log_message("Hello, world!")
options(log_message.verbose = TRUE)

# cli formatting
log_message("hello, {.arg world}!")
message("hello, {.arg world}!")
log_message("hello, {.code world}!")
message("hello, {.code world}!")
log_message("{.emph R}")
log_message("Hello, {.file world}!")
log_message("press {.kbd ENTER}")
log_message("address: {.email example@example.com}")
log_message("URL: {.url https://example.com}")
log_message("Some {.field field}")
log_message("Hello, {.pkg world}!")
log_message("Hello, {.val world}!")

# set indentation
log_message("Hello, world!", level = 2)
log_message("Hello, world!", symbol = "->")

# multiline message
log_message("Line 1\nLine 2\nLine 3", multiline_indent = TRUE)
log_message(
  "Multi-line\ncolored\nmessage",
  text_color = "blue",
  multiline_indent = FALSE
)
log_message(
  "Multi-line\ncolored\nmessage",
  text_color = "blue",
  multiline_indent = FALSE,
  timestamp = FALSE
)

# color formatting
log_message(
  "This is a red message",
  text_color = "red"
)
log_message(
  "This is a message with background",
  back_color = "cyan"
)
log_message(
  "This is a message with both text and background",
  text_color = "red",
  back_color = "cyan"
)
# color formatting also works with `cli_model = FALSE`
log_message(
  "This is a red message",
  text_color = "red",
  cli_model = FALSE
)
log_message(
  "This is a message with background",
  back_color = "cyan",
  cli_model = FALSE
)
log_message(
  "This is a message with both text and background",
  text_color = "red",
  back_color = "cyan",
  cli_model = FALSE
)

# cli variables
fun <- function(x) {
  log_message("{.val x}")
  log_message("{.val {x}}")
  log_message("{.val {x + 1}}")
}
fun(1)
}
\references{
\url{https://cli.r-lib.org/articles/index.html}
}
