% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sounding_plot.R
\name{sounding_plot}
\alias{sounding_plot}
\title{Plot Skew-T, hodograph and convective indices on a single layout}
\usage{
sounding_plot(
  pressure,
  altitude,
  temp,
  dpt,
  wd,
  ws,
  title = "",
  parcel = "MU",
  max_speed = 25,
  buoyancy_polygon = TRUE,
  SRH_polygon = "03km_RM",
  DCAPE = FALSE,
  meanlayer_bottom_top = c(0, 500),
  storm_motion = c(999, 999),
  ...
)
}
\arguments{
\item{pressure}{pressure [hPa]}

\item{altitude}{altitude [m] (can be above sea level or above ground level as function always consider first level as surface, i.e h = 0 m) - altitude [meters]}

\item{temp}{temperature [degree Celsius]}

\item{dpt}{dew point temperature [degree Celsius]}

\item{wd}{wind direction [azimuth in degrees]}

\item{ws}{wind speed [knots]}

\item{title}{title to be added in the layout's header}

\item{parcel}{parcel tracing on Skew-T for "MU", "ML" or "SB" parcel, "none" for no parcel line.}

\item{max_speed}{range of the hodograph to be drawn, 25 m/s used as default}

\item{buoyancy_polygon}{logical, plotting area of parcel's positive (yellow) or negative (red) buoyancy (default  = TRUE)}

\item{SRH_polygon}{draws polygon for storm-relative helicity, available options are "0500m", "01km", "03km", "36km", "none", "03km" used as default}

\item{DCAPE}{draws downdraft parcel and polygon of downdraft's negative buoyancy (default = FALSE)}

\item{meanlayer_bottom_top}{(optional) vector of length 2 for bottom and top heights used for computing parcel starting parameters; default: 0, 500}

\item{storm_motion}{(optional) for moving storms only - one can define vector of length two with
wind speed [m/s] and wind directions [degrees] that will be used to compute adjusted SRH parameters}

\item{...}{extra graphical arguments to be added}
}
\value{
panel of Skew-T, hodograph and table with convective indices drawn on a pre-defined single layout
}
\description{
Function to plot a composite graphics with Skew-T, hodograph and selected convective parameters on a single layout
}
\examples{
data("sounding_vienna")
sounding_vienna = na.omit(sounding_vienna)
sounding_plot(sounding_vienna$pressure, sounding_vienna$altitude,
  sounding_vienna$temp, sounding_vienna$dpt,
  sounding_vienna$wd, sounding_vienna$ws,
  parcel = "MU", title = "Vienna - 23 August 2011, 12:00 UTC"
)
}
