% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tribble.R
\name{tribble}
\alias{tribble}
\title{Row-wise tibble creation}
\usage{
tribble(...)
}
\arguments{
\item{...}{Arguments specifying the structure of a \code{tibble}.
Variable names should be formulas, and may only appear before the
data. These arguments support \link[rlang:tidy-dots]{tidy dots}.}
}
\value{
A \link{tibble}.
}
\description{
\Sexpr[results=rd, stage=render]{tibble:::lifecycle("maturing")}

Create \link{tibble}s using an easier to read row-by-row layout.
This is useful for small tables of data where readability is
important.  Please see \link{tibble-package} for a general introduction.
}
\examples{
tribble(
  ~colA, ~colB,
  "a",   1,
  "b",   2,
  "c",   3
)

# tribble will create a list column if the value in any cell is
# not a scalar
tribble(
  ~x,  ~y,
  "a", 1:3,
  "b", 4:6
)
}
