% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tribble.R
\name{frame_matrix}
\alias{frame_matrix}
\title{Row-wise matrix creation}
\usage{
frame_matrix(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>
Arguments specifying the structure of a \code{frame_matrix}.
Column names should be formulas, and may only appear before the data.
These arguments are processed with \code{\link[rlang:list2]{rlang::list2()}}
and support unquote via \code{\link{!!}} and unquote-splice via \code{\link{!!!}}.}
}
\value{
A \link{matrix}.
}
\description{
\lifecycle{maturing}

Create matrices laying out the data in rows, similar to
\code{matrix(..., byrow = TRUE)}, with a nicer-to-read syntax.
This is useful for small matrices, e.g. covariance matrices, where readability
is important. The syntax is inspired by \code{\link[=tribble]{tribble()}}.
}
\examples{
frame_matrix(
  ~col1, ~col2,
  1,     3,
  5,     2
)
}
\seealso{
See \link{quasiquotation} for more details on tidy dots semantics,
i.e. exactly how  the \code{...} argument is processed.
}
