% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pillar.R
\name{num}
\alias{num}
\alias{set_num_opts}
\title{Format a numeric vector}
\usage{
num(
  x,
  ...,
  sigfig = NULL,
  digits = NULL,
  label = NULL,
  scale = NULL,
  notation = c("fit", "dec", "sci", "eng", "si"),
  fixed_exponent = NULL,
  extra_sigfig = NULL
)

set_num_opts(
  x,
  ...,
  sigfig = NULL,
  digits = NULL,
  label = NULL,
  scale = NULL,
  notation = c("fit", "dec", "sci", "eng", "si"),
  fixed_exponent = NULL,
  extra_sigfig = NULL
)
}
\arguments{
\item{x}{A numeric vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{sigfig}{Define the number of significant digits to show. Must be one or greater.
The \code{"pillar.sigfig"} \link[pillar:pillar_options]{option} is not consulted.
Can't be combined with \code{digits}.}

\item{digits}{Number of digits after the decimal points to show.
Positive numbers specify the exact number of digits to show.
Negative numbers specify (after negation) the maximum number of digits to show.
With \code{digits = 2}, the numbers 1.2 and 1.234 are printed as 1.20 and 1.23,
with \code{digits = -2} as 1.2 and 1.23, respectively.
Can't be combined with \code{sigfig}.}

\item{label}{A label to show instead of the type description.}

\item{scale}{Multiplier to apply to the data before showing.
Useful for displaying e.g. percentages.
Must be combined with \code{label}.}

\item{notation}{One of \code{"fit"}, \code{"dec"}, \code{"sci"}, \code{"eng"}, or \code{"si"}.
\itemize{
\item \code{"fit"}: Use decimal notation if it fits and if it consumes 13 digits or less,
otherwise use scientific notation. (The default for numeric pillars.)
\item \code{"dec"}: Use decimal notation, regardless of width.
\item \code{"sci"}: Use scientific notation.
\item \code{"eng"}: Use engineering notation, i.e. scientific notation
using exponents that are a multiple of three.
\item \code{"si"}: Use SI notation, prefixes between \code{1e-24} and \code{1e24} are supported.
}}

\item{fixed_exponent}{Use the same exponent for all numbers in scientific, engineering or SI notation.
\code{-Inf} uses the smallest, \code{+Inf} the largest fixed_exponent present in the data.
The default is to use varying exponents.}

\item{extra_sigfig}{If \code{TRUE}, increase the number of significant digits if the data consists of
numbers of the same magnitude with subtle differences.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Constructs a numeric vector that can be formatted with predefined
significant digits, or with a maximum or fixed number of digits
after the decimal point.
Scaling is supported, as well as forcing a decimal, scientific
or engineering notation.
If a label is given, it is shown in the header of a column.

The formatting is applied when the vector is printed or formatted,
and also in a tibble column.
The formatting annotation and the class survives most arithmetic transformations,
the most notable exceptions are \code{\link[=var]{var()}} and \code{\link[=sd]{sd()}}.

\code{set_num_opts()} adds formatting options to an arbitrary numeric vector,
useful for composing with other types.
}
\examples{
# Display as a vector
num(9:11 * 100 + 0.5)

# Significant figures
tibble(
  x3 = num(9:11 * 100 + 0.5, sigfig = 3),
  x4 = num(9:11 * 100 + 0.5, sigfig = 4),
  x5 = num(9:11 * 100 + 0.5, sigfig = 5),
)

# Maximum digits after the decimal points
tibble(
  x0 = num(9:11 * 100 + 0.5, digits = 0),
  x1 = num(9:11 * 100 + 0.5, digits = -1),
  x2 = num(9:11 * 100 + 0.5, digits = -2),
)

# Use fixed digits and a currency label
tibble(
  usd = num(9:11 * 100 + 0.5, digits = 2, label = "USD"),
  gbp = num(9:11 * 100 + 0.5, digits = 2, label = "£"),
  chf = num(9:11 * 100 + 0.5, digits = 2, label = "SFr")
)

# Scale
tibble(
  small  = num(9:11 / 1000 + 0.00005, label = "\%", scale = 100),
  medium = num(9:11 / 100 + 0.0005, label = "\%", scale = 100),
  large  = num(9:11 / 10 + 0.005, label = "\%", scale = 100)
)

# Notation
tibble(
  sci = num(10^(-13:6), notation = "sci"),
  eng = num(10^(-13:6), notation = "eng"),
  si  = num(10^(-13:6), notation = "si"),
  dec = num(10^(-13:6), notation = "dec")
)

# Fixed exponent
tibble(
  scimin = num(10^(-7:6) * 123, notation = "sci", fixed_exponent = -Inf),
  engmin = num(10^(-7:6) * 123, notation = "eng", fixed_exponent = -Inf),
  simin  = num(10^(-7:6) * 123, notation = "si", fixed_exponent = -Inf)
)

tibble(
  scismall = num(10^(-7:6) * 123, notation = "sci", fixed_exponent = -3),
  scilarge = num(10^(-7:6) * 123, notation = "sci", fixed_exponent = 3),
  scimax   = num(10^(-7:6) * 123, notation = "sci", fixed_exponent = Inf)
)

#' Extra significant digits
tibble(
  default = num(100 + 1:3 * 0.001),
  extra1 = num(100 + 1:3 * 0.001, extra_sigfig = TRUE),
  extra2 = num(100 + 1:3 * 0.0001, extra_sigfig = TRUE),
  extra3 = num(10000 + 1:3 * 0.00001, extra_sigfig = TRUE)
)
}
\seealso{
Other vector classes: 
\code{\link{char}()}
}
\concept{vector classes}
