#' Simulated data for mixture model with ordinal indicators
#'
#' This simulated dataset, based on the 'Mplus' User's Guide example 7.6,
#' contains four columns of integer data that should be treated as ordinal.
#'
#' \tabular{lll}{
#'   \strong{u1} \tab \code{integer} \tab Indicator 1, should be treated as
#'   ordinal.\cr
#'   \strong{u2} \tab \code{integer} \tab Indicator 2, should be treated as
#'   ordinal.\cr
#'   \strong{u3} \tab \code{integer} \tab Indicator 3, should be treated as
#'   ordinal.\cr
#'   \strong{u4} \tab \code{integer} \tab Indicator 4, should be treated as
#'   ordinal.
#' }
#' @docType data
#' @keywords datasets
#' @name data_mix_ordinal
#' @usage data(data_mix_ordinal)
#' @references Muthén, L.K. and Muthén, B.O. (1998-2017). Mplus User's Guide.
#' Eighth Edition. Los Angeles, CA: Muthén & Muthén
#' @format A data frame with 5000 rows and 4 variables.
NULL
