% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax-run.R
\name{run_lavaan}
\alias{run_lavaan}
\title{Run as lavaan model}
\usage{
run_lavaan(x, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{...}{Parameters passed on to other functions.}
}
\value{
Returns a lavaan object.
}
\description{
This convenience function runs objects for which a method exists
using lavaan. It is intended for use with
\code{tidySEM}, and passes the \code{$syntax} and \code{$data} elements of a
\code{tidy_sem} object on to \code{\link[lavaan]{lavaan}}.
}
\examples{
df <- iris[1:3]
names(df) <- paste0("X_", 1:3)
run_lavaan(measurement(tidy_sem(df), meanstructure = TRUE))
}
