% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results-table_fit.R
\name{table_fit}
\alias{table_fit}
\title{Print model fit table formatted for publication}
\usage{
table_fit(x, ...)
}
\arguments{
\item{x}{A model object for which a method exists.}

\item{...}{Arguments passed to other functions.}
}
\value{
A data.frame of formatted results.
}
\description{
Takes a model object, extracts model fit information, and formats it as a
publication-ready table.
}
\examples{
library(lavaan)
HS.model <- '  visual =~ x1 + x2 + x3
               textual =~ x4 + x5 + x6
               speed   =~ x7 + x8 + x9 '
fit <- cfa(HS.model,
           data = HolzingerSwineford1939,
           group = "school")
table_fit(fit)
}
\seealso{
Other Reporting tools: 
\code{\link{conf_int}()},
\code{\link{est_sig}()},
\code{\link{table_prob}()},
\code{\link{table_results}()}
}
\author{
Caspar J. van Lissa
}
\concept{Reporting tools}
\keyword{reporting}
