% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dice.R
\name{plot_single_dice}
\alias{plot_single_dice}
\title{Draw a single dice}
\usage{
plot_single_dice(ggplot = NULL, result = 6, x = 0, y = 0,
  width = 0.9, fill = "white", detailed = TRUE,
  rounding = dice_width/5, line_size = 0.8, line_color = "black",
  point_size = width/6, point_color = "black")
}
\arguments{
\item{ggplot}{ggplot-Object. If passed, the dice will be added to plot}

\item{result}{Result of dice rolling (0..6)}

\item{x}{X-coordinate of dice (center)}

\item{y}{y-coordinate of dice (center)}

\item{width}{Width of dice}

\item{fill}{Fill color}

\item{detailed}{If TRUE, the dice is plotted with more details}

\item{rounding}{Rounding of dice (only used if detailed == TRUE)}

\item{line_size}{Size of Lines}

\item{line_color}{Color of Lines}

\item{point_size}{Size of Points}

\item{point_color}{Color of Points}
}
\value{
ggplot-Object
}
\description{
Draw a single dice
}
