% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_factors.R
\name{download_data_factors_q}
\alias{download_data_factors_q}
\title{Download and Process Global Q Factor Data}
\usage{
download_data_factors_q(
  type,
  start_date = NULL,
  end_date = NULL,
  url = "https://global-q.org/uploads/1/2/2/6/122679606/"
)
}
\arguments{
\item{type}{The type of dataset to download (e.g., "factors_q5_daily",
"factors_q5_monthly").}

\item{start_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, the full dataset is returned.}

\item{end_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the end date for the data. If not provided, the full dataset is returned.}

\item{url}{The base URL from which to download the dataset files, with a
specific path for Global Q datasets.}
}
\value{
A tibble with processed factor data, including the date, risk-free
rate, market excess return, and other factors, filtered by the specified
date range.
}
\description{
Downloads and processes Global Q factor data based on the specified type
(daily, monthly, etc.), date range, and source URL. The function first checks
if the specified type is supported, identifies the dataset name from the
supported types, then downloads and processes the data from the provided URL.
The processing includes date conversion, renaming variables to a standardized
format, scaling factor values, and filtering by the specified date range.
}
\examples{
\donttest{
  download_data_factors_q("factors_q5_daily", "2020-01-01", "2020-12-31")
  download_data_factors_q("factors_q5_annual")
}
}
