% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{fst}
\alias{fst}
\alias{parse_fst}
\alias{slice_fst}
\alias{select_fst}
\alias{filter_fst}
\title{Parse,inspect and extract data.table from fst file}
\usage{
parse_fst(path)

slice_fst(ft, row_no)

select_fst(ft, ...)

filter_fst(ft, ...)
}
\arguments{
\item{path}{path to fst file}

\item{ft}{An object of class fst_table, returned by \code{parse_fst}}

\item{row_no}{An integer vector (Positive)}

\item{...}{The filter conditions}
}
\value{
\code{parse_fst} returns a fst_table class.

\code{select_fst} and \code{filter_fst} returns a data.table.
}
\description{
An API for reading fst file as data.table.
}
\examples{

\dontrun{
  fst::write_fst(iris,"iris_test.fst")
  # parse the file but not reading it
  parse_fst("iris_test.fst") -> ft
  ft

  class(ft)
  lapply(ft,class)
  names(ft)
  dim(ft)

  # get the data by query
  ft \%>\% slice_fst(1:3)
  ft \%>\% slice_fst(c(1,3))

  ft \%>\% select_fst(Sepal.Length)
  ft \%>\% select_fst(Sepal.Length,Sepal.Width)
  ft \%>\% select_fst("Sepal.Length")
  ft \%>\% select_fst(1:3)
  ft \%>\% select_fst(1,3)
  ft \%>\% select_fst("Se")
  ft \%>\% select_fst("nothing")
  ft \%>\% select_fst("Se|Sp")
  ft \%>\% select_fst(cols = names(iris)[2:3])

  ft \%>\% filter_fst(Sepal.Width > 3)
  ft \%>\% filter_fst(Sepal.Length > 6 , Species == "virginica")
  ft \%>\% filter_fst(Sepal.Length > 6 & Species == "virginica" & Sepal.Width < 3)

  unlink("iris_test.fst")
}
}
\seealso{
\code{\link[fst]{fst}}
}
