% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cfg.R
\name{KernelSmooth_cfg}
\alias{KernelSmooth_cfg}
\title{Configuration for a Kernel Smoother}
\description{
\code{KernelSmooth_cfg} is a configuration class for non-parametric local-linear
regression to construct a smooth representation of the relationship between
two variables. This is typically used for displaying a surface of the conditional
average treatment effect over a continuous covariate.

Kernel smoothing is handled by the \code{nprobust} package.
}
\examples{

## ------------------------------------------------
## Method `KernelSmooth_cfg$new`
## ------------------------------------------------

KernelSmooth_cfg$new(neval = 100)
}
\seealso{
\link[nprobust:lprobust]{nprobust::lprobust}
}
\section{Super class}{
\code{\link[tidyhte:Model_cfg]{tidyhte::Model_cfg}} -> \code{KernelSmooth_cfg}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model_class}}{The class of the model, required for all classes
which inherit from \code{Model_cfg}.}

\item{\code{neval}}{The number of points at which to evaluate the local
regression. More points will provide a smoother line at the cost
of somewhat higher computation.}

\item{\code{eval_min_quantile}}{Minimum quantile at which to evaluate the smoother.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KernelSmooth_cfg-new}{\code{KernelSmooth_cfg$new()}}
\item \href{#method-KernelSmooth_cfg-clone}{\code{KernelSmooth_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelSmooth_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-KernelSmooth_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{KernelSmooth_cfg} object with specified number of evaluation points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelSmooth_cfg$new(neval = 100, eval_min_quantile = 0.05)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{neval}}{The number of points at which to evaluate the local
regression. More points will provide a smoother line at the cost
of somewhat higher computation.}

\item{\code{eval_min_quantile}}{Minimum quantile at which to evaluate the smoother.
A value of zero will do no clipping. Clipping is performed from both the
top and the bottom of the empirical distribution. A value of alpha would
evaluate over [alpha, 1 - alpha].}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{KernelSmooth_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{KernelSmooth_cfg$new(neval = 100)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelSmooth_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KernelSmooth_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelSmooth_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
