% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-methods.R
\name{glance.tidylda}
\alias{glance.tidylda}
\title{Glance method for \code{tidylda} objects}
\usage{
\method{glance}{tidylda}(x, ...)
}
\arguments{
\item{x}{an object of class \code{tidylda}}

\item{...}{other arguments passed to methods,currently not used}
}
\value{
\code{glance} returns a one-row \code{\link[tibble]{tibble}} with the
  following columns:

  \code{num_topics}: the number of topics in the model
  \code{num_documents}: the number of documents used for fitting
  \code{num_tokens}: the number of tokens covered by the model
  \code{iterations}: number of total Gibbs iterations run
  \code{burnin}: number of burn-in Gibbs iterations run
}
\description{
\code{glance} constructs a single-row summary "glance" of a \code{tidylda}
  topic model.
}
\examples{
\donttest{
dtm <- textmineR::nih_sample_dtm

lda <- tidylda(data = dtm, k = 10, iterations = 100, burnin = 75)

glance(lda)
}
}
