% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_mistral.R
\name{fetch_mistral_batch}
\alias{fetch_mistral_batch}
\title{Fetch Results for an Mistral Batch}
\usage{
fetch_mistral_batch(
  .llms,
  .batch_id = NULL,
  .dry_run = FALSE,
  .max_tries = 3,
  .timeout = 60
)
}
\arguments{
\item{.llms}{A list of \code{LLMMessage} objects that were part of the batch.}

\item{.batch_id}{Character; the unique identifier for the batch. By default this is NULL
and the function will attempt to use the \code{batch_id} attribute from \code{.llms}.}

\item{.dry_run}{Logical; if \code{TRUE}, returns the constructed request without executing it (default: \code{FALSE}).}

\item{.max_tries}{Integer; maximum number of retries if the request fails (default: \code{3}).}

\item{.timeout}{Integer; request timeout in seconds (default: \code{60}).}
}
\value{
A list of updated \code{LLMMessage} objects, each with the assistant's response added if successful.
}
\description{
This function retrieves the results of a completed Mistral batch and updates
the provided list of \code{LLMMessage} objects with the responses. It aligns each
response with the original request using the \code{custom_id}s generated in \code{send_mistral_batch()}.
}
