% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.R
\name{norm_deltaF}
\alias{norm_deltaF}
\title{Delta F Normalize}
\usage{
norm_deltaF(
  .data,
  ...,
  .by = NULL,
  .by_formant = FALSE,
  .drop_orig = FALSE,
  .keep_params = FALSE,
  .names = "{.formant}_df",
  .silent = FALSE
)
}
\arguments{
\item{.data}{A data frame containing vowel formant data}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant
data columns.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A selection of
columns to group by. Typically a column of speaker IDs.}

\item{.by_formant}{Ignored by this procedure}

\item{.drop_orig}{Whether or not to drop the original formant data columns.}

\item{.keep_params}{Whether or not to keep the Location (\verb{*_.L}) and Scale
(\verb{*_.S}) normalization parameters}

\item{.names}{A \code{\link[glue:glue]{glue::glue()}} expression for naming the normalized
data columns. The \code{"{.formant}"} portion corresponds to the name of the original
formant columns.}

\item{.silent}{Whether or not the informational message should be printed.}
}
\value{
A data frame of Delta F normalized formant values.
}
\description{
Delta F Normalize
}
\details{
\deqn{
 \hat{F}_{ij} = \frac{F_{ij}}{S}
}
\deqn{
 S = \frac{1}{MN}\sum_{i=1}^M\sum_{j=1}^N \frac{F_{ij}}{i-0.5}
}

Where
\itemize{
\item \eqn{\hat{F}} is the normalized formant
\item \eqn{i} is the formant number
\item \eqn{j} is the token number
}
}
\examples{
library(tidynorm)
ggplot2_inst <- require(ggplot2)

speaker_data_deltaF <- speaker_data |>
  norm_deltaF(
    F1:F3,
    .by = speaker,
    .names = "{.formant}_df"
  )

if (ggplot2_inst) {
  ggplot(
    speaker_data_deltaF,
    aes(
      F2_df,
      F1_df,
      color = speaker
    )
  ) +
    stat_density_2d(
      bins = 4
    ) +
    scale_color_brewer(
      palette = "Dark2"
    ) +
    scale_x_reverse() +
    scale_y_reverse() +
    coord_fixed()
}
}
\references{
Johnson, K. (2020). The \eqn{\Delta}F method of vocal tract length normalization for vowels.
Laboratory Phonology: Journal of the Association for Laboratory Phonology, 11(1),
Article 1. \doi{10.5334/labphon.196}
}
