% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{alta_lake_210Pb_ages}
\alias{alta_lake_210Pb_ages}
\alias{alta_lake_14C_ages}
\alias{alta_lake_bacon_ages}
\alias{alta_lake_geochem}
\title{Alta Lake Lead-210 and Carbon-14 Ages}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 9 rows and 5 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1 rows and 5 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 58 rows and 5 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 192 rows and 9 columns.
}
\usage{
alta_lake_210Pb_ages

alta_lake_14C_ages

alta_lake_bacon_ages

alta_lake_geochem
}
\description{
The \code{alta_lake_210Pb_ages} object contains raw depths and ages for Alta
Lake (Whistler, British Columbia, Canada) core AL-GC2 (Dunnington et al.
2016; Dunnington 2015). For these values, ages were calculated from Lead-210
activities using the constant rate of supply (CRS) model (Appleby and
Oldfield 1983). The \code{alta_lake_14C_ages} object contains one
uncalibrated Carbon-14 measurement from the same core.
The \code{alta_lake_bacon_ages} object contains the combined result of the
Lead-210 and the Carbon-14 ages as modelled by the rbacon package
(Blaauw and Christen 2011).
}
\examples{
alta_lake_210Pb_ages
alta_lake_14C_ages
alta_lake_bacon_ages

}
\references{
Appleby, P. G., and F. Oldfield. "The Assessment of 210Pb Data from Sites
with Varying Sediment Accumulation Rates." Hydrobiologia 103, no. 1 (July 1,
1983): 29–35. \doi{10.1007/BF00028424}.

Blaauw, Maarten, and J. Andrés Christen. "Flexible Paleoclimate Age-Depth
Models Using an Autoregressive Gamma Process." Bayesian Analysis 6, no. 3
(September 2011): 457–74. \doi{10.1214/ba/1339616472}.

Dunnington, Dewey W., Ian S. Spooner, Chris E. White, R. Jack Cornett, Dave
Williamson, and Mike Nelson. "A Geochemical Perspective on the Impact of
Development at Alta Lake, British Columbia, Canada." Journal of
Paleolimnology 56, no. 4 (November 2016): 315–330.
\doi{10.1007/s10933-016-9919-x}.

Dunnington, Dewey W. "A 500-Year Applied Paleolimnological Assessment of
Environmental Change at Alta Lake, Whistler, British Columbia, Canada." M.Sc.
Thesis, Acadia University, 2015.
\url{https://scholar.acadiau.ca/islandora/object/theses:411}.
}
\keyword{datasets}
