% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_prcomp.R
\name{nested_prcomp}
\alias{nested_prcomp}
\title{Nested Principal Components Analysis (PCA)}
\usage{
nested_prcomp(.data, data_column = .data$data, ...)
}
\arguments{
\item{.data}{A data frame with a list column of data frames, possibly created using
\link{nested_data}.}

\item{data_column}{An expression that evalulates to the data object within each row of .data}

\item{...}{Passed to \link[stats:prcomp]{prcomp}.}
}
\value{
.data with additional columns 'model', 'loadings', 'variance' and 'scores'
}
\description{
Powered by \link[stats:prcomp]{prcomp}. When creating the \link{nested_data},
the data should be scaled (i.e, \code{trans = scale}) if all variables are not
in the same unit.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

nested_pca <- alta_lake_geochem \%>\%
  nested_data(
    qualifiers = c(depth, zone),
    key = param,
    value = value,
    trans = scale
  ) \%>\%
  nested_prcomp()

# get variance info
nested_pca \%>\% unnested_data(variance)

# get loadings info
nested_pca \%>\% unnested_data(loadings)

# scores, requalified
nested_pca \%>\% unnested_data(c(qualifiers, scores))

}
