% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\docType{data}
\name{no_trans}
\alias{no_trans}
\alias{logit_trans}
\alias{Fisher_trans}
\alias{ln_trans}
\alias{inv_trans}
\title{Simple Transformation Functions}
\format{
An object of class \code{list} of length 2.

An object of class \code{list} of length 2.

An object of class \code{list} of length 2.

An object of class \code{list} of length 2.

An object of class \code{list} of length 2.
}
\usage{
no_trans

logit_trans

Fisher_trans

ln_trans

inv_trans
}
\description{
A set of objects are contained here to easily facilitate the
use of outcome transformations for modeling. For example, if
there is a large amount of variability in the resampling results
for the Kappa statistics, which lies between -1 and 1, assuming
normality may produce posterior estimates outside of the natural
bound. One way to solve this is to use a link function or assume
a prior that is appropriately bounded. Another approach is to
transform the outcome values prior to modeling using a Gaussian
prior and reverse-transforming the posterior estimates prior to
visualization and summarization. These object can help
facilitate this last approach.
}
\details{
The \code{logit_trans} object is useful for model
performance statistics bounds in zero and one, such as accuracy
or the area under the ROC curve.

\code{ln_trans} and \code{inv_trans} can be useful when the statistics
are right-skewed and strictly positive.

\code{Fisher_trans} was originally used for correlation statistics
but can be used here for an metrics falling between -1 and 1,
such as Kappa.
}
\examples{
logit_trans$func(.5)
logit_trans$inv(0)
}
\keyword{datasets}
