% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_using_tools.R
\name{answer_using_tools}
\alias{answer_using_tools}
\title{Enable LLM to call R functions}
\usage{
answer_using_tools(
  prompt,
  tools = list(),
  type = c("text-based", "auto", "openai", "ollama")
)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{tools}{An R function or a list of R functions that the LLM can call.
If the function has been documented in a help file (e.g., because it is part of a
package), the documentation will be parsed from the help file. If it is a custom
function, documentation should be added with \code{\link[=tools_add_docs]{tools_add_docs()}}}

\item{type}{(optional) The way that tool calling should be enabled.
'auto' will automatically determine the type based on 'llm_provider$api_type'
(note that this does not consider model compatibility, and could lead to errors;
set 'type' manually if errors occur). 'openai' and 'ollama' will set the
relevant API parameters. 'text-based' will provide function definitions
in the prompt, extract function calls from the LLM response, and call the
functions, providing the results back via \code{\link[=llm_feedback]{llm_feedback()}}. 'text-based'
always works, but may be inefficient for APIs that support tool calling
natively. However, 'text-based' may be more reliable and flexible, especially
when combining with other prompt wraps. 'openai' and 'ollama' may not allow
for retries if the function call did not provide the expected result. Note that
when using 'openai' or 'ollama', tool calls are not counted as interactions and
may continue indefinitely (use with caution)}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which
will allow the LLM to call R functions
}
\description{
This function adds the ability for the a LLM to call R functions.
Users can specify a list of functions that the LLM can call, and the
prompt will be modified to include information, as well as an
accompanying extraction function to call the functions (handled by
\code{\link[=send_prompt]{send_prompt()}}). Documentation for the functions is extracted from
the help file (if available), or from documentation added by
\code{\link[=tools_add_docs]{tools_add_docs()}}
}
\details{
Note that this method of function calling is purely text-based.
This makes it suitable for any LLM and any LLM provider. However,
'native' function calling (where the LLM model provider restricts the
model to special tokens that can be used to call functions) may perform
better in terms of accuracy and efficiency. 'tidyprompt' may support
'native' function calling in the future
}
\examples{
\dontrun{
  # When using functions from base R or R packages,
  #   documentation is automatically extracted from help files:
  "What are the files in my current directory?" |>
    answer_using_tools(dir) |> # 'dir' function is from base R
    send_prompt()
}

# Custom functions may also be provided;
#   in this case, some documentation is extracted from the function's formals;
#   descriptions may be added manually. See below

# Example fake weather function to add to the prompt:
temperature_in_location <- function(
    location = c("Amsterdam", "Utrecht", "Enschede"),
    unit = c("Celcius", "Fahrenheit")
) {
  location <- match.arg(location)
  unit <- match.arg(unit)

  temperature_celcius <- switch(
    location,
    "Amsterdam" = 32.5,
    "Utrecht" = 19.8,
    "Enschede" = 22.7
  )

  if (unit == "Celcius") {
    return(temperature_celcius)
  } else {
    return(temperature_celcius * 9/5 + 32)
  }
}

# Generate documentation for a function
#   (based on formals, & help file if available)
docs <- tools_get_docs(temperature_in_location)

# The types get inferred from the function's formals
# However, descriptions are still missing as the function is not from a package
# We can modify the documentation object to add descriptions:
docs$description <- "Get the temperature in a location"
docs$arguments$unit$description <- "Unit in which to return the temperature"
docs$arguments$location$description <- "Location for which to return the temperature"
docs$return$description <- "The temperature in the specified location and unit"
# (See `?tools_add_docs` for more details on the structure of the documentation)

# When we are satisfied with the documentation, we can add it to the function:
temperature_in_location <- tools_add_docs(temperature_in_location, docs)

\dontrun{
  # Now the LLM can use the function:
  "Hi, what is the weather in Enschede? Give me Celcius degrees" |>
    answer_using_tools(temperature_in_location) |>
    send_prompt()
}
}
\seealso{
\code{\link[=answer_using_r]{answer_using_r()}} \code{\link[=tools_get_docs]{tools_get_docs()}}

Other pre_built_prompt_wraps: 
\code{\link{add_text}()},
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_using_prompt_wraps: 
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()}

Other tools: 
\code{\link{tools_add_docs}()},
\code{\link{tools_get_docs}()}
}
\concept{answer_using_prompt_wraps}
\concept{pre_built_prompt_wraps}
\concept{tools}
