% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as_tibble}
\alias{as_tibble}
\title{DEPRECATED: Coerce to tibble. Enable preserving row names when coercing matrix
and time-series-like objects with row names.}
\usage{
as_tibble(x, preserve_row_names = FALSE, ...)
}
\arguments{
\item{x}{A list, matrix, xts, zoo, timeSeries, etc object.}

\item{preserve_row_names}{Used during coercion from matrix, xts, zoo,
timeSeries, etc objects that have row names. When \code{TRUE}, creates
a \code{row.names} column with names of rows as character class.}

\item{...}{Additional parameters passed to the appropriate
\code{\link[timetk:tk_tbl]{timetk::tk_tbl()}} function.}
}
\value{
Returns a \code{tibble} object.
}
\description{
Coerce to tibble. Enable preserving row names when coercing matrix
and time-series-like objects with row names.

DEPRECATED: Use \code{\link[timetk:tk_tbl]{timetk::tk_tbl()}} instead.
}
\details{
\code{as_tibble} is a wrapper for \code{tibble::as_tibble}
that includes a \code{preserve_row_names} argument. The function is designed
to coerce \code{xts}, \code{zoo}, \code{timeSeries}, \code{ts}, and \code{irts}
objects that are used frequently in quantitative financial analysis.
When \code{preserve_row_names = TRUE} is specified, a new column,
\code{row.names}, is created during object coercion as a character class.
}
\examples{
# Load libraries
library(tidyquant)

# Matrix coercion to tibble
m <- matrix(rnorm(50), ncol = 5)
colnames(m) <- c("a", "b", "c", "d", "e")
rownames(m) <- letters[1:nrow(m)]
m_tbl <- as_tibble(m, preserve_row_names = TRUE)

# xts coercion to tibble
quantmod::getSymbols("AAPL", auto.assign = FALSE) \%>\%
    as_tibble(preserve_row_names = TRUE)

}
\seealso{
\itemize{
\item \code{\link[=tk_xts]{tk_xts()}} - Coercion to xts, replaces \code{\link[tidyquant:as_xts]{tidyquant::as_xts()}}
\item \code{\link[=tk_tbl]{tk_tbl()}} - Coercion to tbl, replaces \code{\link[tidyquant:as_tibble]{tidyquant::as_tibble()}}
\item \code{\link[=as_xts]{as_xts()}} - Deprecated, use \code{\link[=tk_xts]{tk_xts()}} instead.
}
}
