% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{fill}
\alias{fill}
\title{Fill in missing values.}
\usage{
fill(data, ..., .direction = c("down", "up"))
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to fill. Use bare variable names.
Select all variables between x and z with \code{x:z}, exclude y with
\code{-y}. For more options, see the \link[dplyr]{select} documentation.}

\item{.direction}{Direction in which to fill missing values. Currently
either "down" (the default) or "up".}
}
\description{
Fills missing values in using the previous entry. This is useful in the
common output format where values are not repeated, they're recorded
each time they change.
}
\details{
Missing values are replaced in atomic vectors; \code{NULL}s are replaced
in list.
}
\examples{
df <- data.frame(Month = 1:12, Year = c(2000, rep(NA, 11)))
df \%>\% fill(Year)
}
\seealso{
\code{\link{fill_}} for a version that uses regular evaluation
  and is suitable for programming with.
}
