% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_pseudoabs.R
\name{sample_pseudoabs}
\alias{sample_pseudoabs}
\title{Sample pseudo-absence (or background) points for SDM analysis}
\usage{
sample_pseudoabs(
  data,
  raster,
  n,
  coords = NULL,
  method = "random",
  class_label = "pseudoabs",
  return_pres = TRUE
)
}
\arguments{
\item{data}{An \code{\link[sf:sf]{sf::sf}} data frame, or a data frame with coordinate variables.
These can be defined in \code{coords}, unless they have standard names
(see details below).}

\item{raster}{the \link[terra:SpatRaster-class]{terra::SpatRaster} from which cells will be sampled}

\item{n}{number of pseudoabsence/background points to sample}

\item{coords}{a vector of length two giving the names of the "x" and "y"
coordinates, as found in \code{data}. If left to NULL, the function will
try to guess the columns based on standard names \code{c("x", "y")}, \code{c("X","Y")},
\code{c("longitude", "latitude")}, or \code{c("lon", "lat")}}

\item{method}{sampling method. One of 'random', 'dist_min', 'dist_max', or
'dist_disc'. Threshold distances are set as additional elements of a vector,
e.g c('dist_min',70000) or c('dist_disc',50000,200000).}

\item{class_label}{the label given to the sampled points. Defaults to \code{pseudoabs}}

\item{return_pres}{return presences together with pseudoabsences/background
in a single tibble}
}
\value{
An object of class \link[tibble:tibble]{tibble::tibble}. If presences are returned, the
presence level is set as the reference (to match the expectations in the
\code{yardstick} package that considers the first level to be the event)
}
\description{
This function samples pseudo-absence (or background, the naming is a matter
of semantics) points from a raster given a set of presences.
The locations returned as the center points of the sampled cells, which can
not overlap with the presences. The following methods are implemented:
\itemize{
\item 'random': pseudo-absences/background randomly sampled from the region covered by the
raster (i.e. not NAs).
\item 'dist_min': pseudo-absences/background randomly sampled from the region excluding a buffer
of 'dist_min' from presences (distances in 'm' for lonlat rasters, and in map
units for projected rasters).
\item 'dist_max': pseudo-absences/background randomly sampled from the unioned buffers
of 'dist_max' from presences (distances in 'm' for lonlat rasters, and in map
units for projected rasters). Using the union of buffers means that areas that
are in multiple buffers are not oversampled. This is also referred to as "thickening".
\item 'dist_disc': pseudo-absences/background randomly sampled from the unioned discs around presences
with the two values of 'dist_disc' defining the minimum and maximum distance from
presences.
}
}
