% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{join_transcripts}
\alias{join_transcripts}
\title{Add differential transcription information to a tbl using edgeR.}
\usage{
join_transcripts(
  .data,
  transcripts = NULL,
  all = FALSE,
  exclude_zeros = FALSE,
  shape = "long"
)
}
\arguments{
\item{.data}{A `tbl` formatted as | <SAMPLE> | <TRANSCRIPT> | <COUNT> | <...> |}

\item{transcripts}{A formula with no response variable, representing the desired linear model}

\item{all}{The name of the sample column}

\item{exclude_zeros}{The name of the transcript/gene column}

\item{shape}{The name of the transcript/gene abundance column}
}
\value{
A `tbl` with additional columns for the statistics from the hypothesis test (e.g.,  log fold change, p-value and false discovery rate).
}
\description{
join_transcripts() takes as imput a `tbl` formatted as | <SAMPLE> | <TRANSCRIPT> | <COUNT> | <...> | and returns a `tbl` with additional columns for the statistics from the hypothesis test.
}
\details{
\lifecycle{experimental}

At the moment this function uses edgeR only, but other inference algorithms will be added in the near future.
}
\examples{
\donttest{



	join_transcripts(
	    ~ condition,
	    sample,
	    transcript,
	    `count`
	)

}

}
