% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{sample_n}
\alias{sample_n}
\alias{sample_frac}
\title{Sample n rows from a table}
\usage{
sample_n(tbl, size, replace = FALSE, weight = NULL, .env = NULL, ...)

sample_frac(tbl, size = 1, replace = FALSE, weight = NULL, .env = NULL, ...)
}
\arguments{
\item{tbl}{A data.frame.}

\item{size}{<[`tidy-select`][dplyr_tidy_select]>
For `sample_n()`, the number of rows to select.
For `sample_frac()`, the fraction of rows to select.
If `tbl` is grouped, `size` applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{<[`tidy-select`][dplyr_tidy_select]> Sampling weights.
This must evaluate to a vector of non-negative numbers the same length as
the input. Weights are automatically standardised to sum to 1.}

\item{.env}{DEPRECATED.}

\item{...}{ignored}
}
\value{
A tidyseurat object
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("superseded")}
`sample_n()` and `sample_frac()` have been superseded in favour of
[slice_sample()]. While they will not be deprecated in the near future,
retirement means that we will only perform critical bug fixes, so we recommend
moving to the newer alternative.

These functions were superseded because we realised it was more convenient to
have two mutually exclusive arguments to one function, rather than two
separate functions. This also made it to clean up a few other smaller
design issues with `sample_n()`/`sample_frac`:

* The connection to `slice()` was not obvious.
* The name of the first argument, `tbl`, is inconsistent with other
  single table verbs which use `.data`.
* The `size` argument uses tidy evaluation, which is surprising and
  undocumented.
* It was easier to remove the deprecated `.env` argument.
* `...` was in a suboptimal position.
}
\examples{

`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% sample_n(50) 
pbmc_small \%>\% tidy \%>\% sample_frac(0.1)

}
\keyword{internal}
