% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{dt_count}
\alias{dt_count}
\title{Count observations by group}
\usage{
dt_count(.data, ...)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{Optional: Bare column names to group by}
}
\value{
A data.table
}
\description{
Returns row counts of the dataset. If bare column names are provided, \code{dt_count()} returns counts by group.

Supports enhanced selection
}
\examples{
example_df <- data.table::data.table(
  x = 1:3,
  y = 4:6,
  z = c("a", "a", "b"))

example_df \%>\%
  dt_count()

example_df \%>\%
  dt_count(z)

example_df \%>\%
  dt_count(is.character)
}
