% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{nest_by.}
\alias{nest_by.}
\alias{dt_group_nest}
\title{Nest data.tables}
\usage{
nest_by.(.df, ..., .key = "data", .keep = FALSE)

dt_group_nest(.df, ..., .key = "data", .keep = FALSE)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to group by. If empty nests the entire data.table.
\code{tidyselect} compatible.}

\item{.key}{Name of the new column created by nesting.}

\item{.keep}{Should the grouping columns be kept in the list column.}
}
\description{
Nest data.tables by group
}
\examples{
test_df <- data.table(
  a = 1:10,
  b = 11:20,
  c = c(rep("a", 6), rep("b", 4)),
  d = c(rep("a", 4), rep("b", 6)))

test_df \%>\%
  nest_by.()

test_df \%>\%
  nest_by.(c, d)

test_df \%>\%
  nest_by.(where(is.character))

test_df \%>\%
  nest_by.(c, d, .keep = TRUE)
}
