% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice.}
\alias{slice.}
\alias{slice_head.}
\alias{slice_tail.}
\alias{slice_max.}
\alias{slice_min.}
\alias{dt_slice}
\alias{dt_slice_head}
\alias{dt_slice_tail}
\alias{dt_slice_min}
\alias{dt_slice_max}
\title{Choose rows by position}
\usage{
slice.(.df, rows = 1:5, by = NULL)

slice_head.(.df, n = 5, by = NULL)

slice_tail.(.df, n = 5, by = NULL)

slice_max.(.df, order_by, n = 1, by = NULL)

slice_min.(.df, order_by, n = 1, by = NULL)

dt_slice(.df, rows = 1:5, by = NULL)

dt_slice_head(.df, n = 5, by = NULL)

dt_slice_tail(.df, n = 5, by = NULL)

dt_slice_min(.df, order_by, n = 1, by = NULL)

dt_slice_max(.df, order_by, n = 1, by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{rows}{Integer row values. Provide either positive values to keep, or negative values to drop. The values provided must be either all positive or all negative.}

\item{by}{Columns to group by}

\item{n}{Number of rows to grab}

\item{order_by}{Variable to arrange by}
}
\description{
Choose rows by their ordinal position in a data.table. Grouped data.tables use the ordinal position within the group.
}
\examples{
test_df <- data.table(
  x = c(1,2,3,4),
  y = c(4,5,6,7),
  z = c("a","a","a","b"))

test_df \%>\%
  slice.(1:4)

test_df \%>\%
  slice.(1, by = z)

test_df \%>\%
  slice_head.(1, by = z)

test_df \%>\%
  slice_tail.(1, by = z)

test_df \%>\%
  slice_max.(order_by = x, by = z)

test_df \%>\%
  slice_min.(order_by = y, by = z)
}
