% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand.}
\alias{expand.}
\alias{nesting.}
\title{Expand a data.table to use all combinations of values}
\usage{
expand.(.df, ..., .name_repair = "check_unique")

nesting.(..., .name_repair = "check_unique")
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to get combinations of}

\item{.name_repair}{Treatment of duplicate names. See \code{?vctrs::vec_as_names} for options/details}
}
\description{
Generates all combinations of variables found in a dataset.

\code{expand.()} is useful in conjunction with joins:
\itemize{
\item use with \code{right_join.()} to convert implicit missing values to explicit missing values
\item use with \code{anti_join.()} to find out which combinations are missing
}

\code{nesting.()} is a helper that only finds combinations already present in the dataset.
}
\examples{
test_df <- tidytable(x = c(1, 1, 2), y = c(1, 1, 2))

test_df \%>\%
  expand.(x, y)

test_df \%>\%
  expand.(nesting.(x, y))
}
