% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between.R
\name{between.}
\alias{between.}
\title{Do the values from x fall between the left and right bounds?}
\usage{
between.(x, left, right)
}
\arguments{
\item{x}{A numeric vector}

\item{left, right}{Boundary values}
}
\description{
\code{between.()} utilizes \code{data.table::between()} in the background
}
\examples{
test_df <- data.table(
  x = 1:5,
  y = 1:5
)

# Typically used in a filter.()
test_df \%>\%
  filter.(between.(x, 2, 4))

test_df \%>\%
  filter.(x \%>\% between.(2, 4))

# Can also use the \%between\% operator
test_df \%>\%
  filter.(x \%between\% c(2, 4))
}
