% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest.}
\alias{unnest.}
\title{Unnest list-columns}
\usage{
unnest.(
  .df,
  ...,
  keep_empty = FALSE,
  .drop = TRUE,
  names_sep = NULL,
  names_repair = "unique"
)
}
\arguments{
\item{.df}{A data.table}

\item{...}{Columns to unnest. If empty, unnests all list columns. \code{tidyselect} compatible.}

\item{keep_empty}{Return \code{NA} for any \code{NULL} elements of the list column}

\item{.drop}{Should list columns that were not unnested be dropped}

\item{names_sep}{If NULL, the default, the inner column names will become the new outer column names.

If a string, the name of the outer column will be appended to the beginning of the inner column names,
with \code{names_sep} used as a separator.}

\item{names_repair}{Treatment of duplicate names. See \code{?vctrs::vec_as_names} for options/details.}
}
\description{
Unnest list-columns.
}
\examples{
nested_df <-
  data.table(
    a = 1:10,
    b = 11:20,
    c = c(rep("a", 6), rep("b", 4)),
    d = c(rep("a", 4), rep("b", 6))
  ) \%>\%
  nest_by.(c, d) \%>\%
  mutate.(pulled_vec = map.(data, ~ pull.(.x, a)))

nested_df \%>\%
  unnest.(data)

nested_df \%>\%
  unnest.(data, names_sep = "_")

nested_df \%>\%
  unnest.(data, pulled_vec)
}
