% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cross_blended_hypsometric_tints_db}
\alias{cross_blended_hypsometric_tints_db}
\title{Cross-blended hypsometric tints}
\format{
A tibble of 41 rows and
6 columns. with the following
fields:

\describe{
\item{pal}{ Name of the palette.}
\item{limit}{Recommended elevation limit (in meters) for each color.}
\item{r}{Value of the red channel (RGB color mode).}
\item{g}{Value of the green channel (RGB color mode).}
\item{b}{Value of the blue channel (RGB color mode).}
\item{hex}{ Hex code of the color.}
}
}
\source{
Derived from:
\itemize{
\item Patterson, T., & Jenny, B. (2011). The Development and Rationale of
Cross-blended Hypsometric Tints. \emph{Cartographic Perspectives,} (69),
31 - 46. \doi{10.14714/CP69.20}.
}
}
\description{
A \code{\link[tibble:tibble]{tibble}} including the color map of
4 gradient palettes.
All the palettes includes also a definition of colors limits in terms of
elevation (meters), that can be used with \code{\link[ggplot2:scale_gradient]{ggplot2::scale_fill_gradientn()}}.
}
\details{
From Patterson & Jenny (2011):

\emph{More recently, the role and design of hypsometric tints have come under
scrutiny. One reason for this is the concern that people misread
elevation colors as climate or vegetation information. Cross-blended
hypsometric tints, introduced in 2009, are a partial solution to this
problem. They use variable lowland colors customized to match the
differing natural environments of world regions, which merge into
one another.}
}
\examples{
\donttest{

data("cross_blended_hypsometric_tints_db")

cross_blended_hypsometric_tints_db

# Select a palette
warm <- cross_blended_hypsometric_tints_db \%>\%
  filter(pal == "warm_humid")

f <- system.file("extdata/asia.tif", package = "tidyterra")
r <- terra::rast(f)

library(ggplot2)

p <- ggplot() +
  geom_spatraster(data = r) +
  labs(fill = "elevation")

p +
  scale_fill_gradientn(colors = warm$hex)

# Use with limits
p +
  scale_fill_gradientn(
    colors = warm$hex,
    values = scales::rescale(warm$limit),
    limit = range(warm$limit),
    na.value = "lightblue"
  )
}
}
\seealso{
\code{\link[=scale_fill_cross_blended_c]{scale_fill_cross_blended_c()}}

Other datasets: 
\code{\link{grass_db}},
\code{\link{hypsometric_tints_db}},
\code{\link{princess_db}},
\code{\link{volcano2}}
}
\concept{datasets}
