% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-SpatVector.R
\name{fill.SpatVector}
\alias{fill.SpatVector}
\title{Fill in missing values with previous or next value on a \code{SpatVector}}
\usage{
\method{fill}{SpatVector}(data, ..., .direction = c("down", "up", "downup", "updown"))
}
\arguments{
\item{data}{A \code{SpatVector}.}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to fill.}

\item{.direction}{Direction in which to fill missing values. Currently
either "down" (the default), "up", "downup" (i.e. first down and then up)
or "updown" (first up and then down).}
}
\value{
A \code{SpatVector} object.
}
\description{
Fills missing values in selected columns using the next or previous entry.
This is useful in the common output format where values are not repeated,
and are only recorded when they change.
}
\section{Methods}{


Implementation of the \strong{generic} \code{\link[tidyr:fill]{tidyr::fill()}} function for \code{SpatVector}.
}

\section{Grouped \code{SpatVector}}{


With grouped \code{SpatVector} created by \code{\link[=group_by.SpatVector]{group_by.SpatVector()}}, \code{fill()} will
be applied \emph{within} each group, meaning that it won't fill across group
boundaries.
}

\examples{
library(dplyr)

lux <- terra::vect(system.file("ex/lux.shp", package = "terra"))

# Leave some blanks for demo purporses

lux_blnk <- lux \%>\%
  mutate(NAME_1 = if_else(NAME_1 != NAME_2, NA, NAME_2))


as_tibble(lux_blnk)

# `fill()` defaults to replacing missing data from top to bottom
lux_blnk \%>\%
  fill(NAME_1) \%>\%
  as_tibble()


# direction = "up"
lux_blnk \%>\%
  fill(NAME_1, .direction = "up") \%>\%
  as_tibble()

# Grouping and downup - will restore the initial state
lux_blnk \%>\%
  group_by(ID_1) \%>\%
  fill(NAME_1, .direction = "downup") \%>\%
  as_tibble()

}
\seealso{
\code{\link[tidyr:fill]{tidyr::fill()}}

Other \CRANpkg{tidyr} verbs for handling missing values:
\code{\link{drop_na.Spat}},
\code{\link{replace_na.Spat}}

Other \CRANpkg{tidyr} methods:
\code{\link{drop_na.Spat}},
\code{\link{pivot_longer.SpatVector}()},
\code{\link{pivot_wider.SpatVector}()},
\code{\link{replace_na.Spat}}
}
\concept{tidyr.methods}
\concept{tidyr.missing}
