% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiments.R
\name{get_sentiments}
\alias{get_sentiments}
\title{Get a tidy data frame of a single sentiment lexicon}
\usage{
get_sentiments(lexicon = c("bing", "afinn", "loughran", "nrc"))
}
\arguments{
\item{lexicon}{The sentiment lexicon to retrieve;
either "afinn", "bing", "nrc", or "loughran"}
}
\value{
A tbl_df with a \code{word} column, and either a \code{sentiment}
column (if \code{lexicon} is not "afinn") or a numeric \code{value} column
(if \code{lexicon} is "afinn").
}
\description{
Get specific sentiment lexicons in a tidy format, with one row per word,
in a form that can be joined with a one-word-per-row dataset.
The \code{"bing"} option comes from the included \code{\link{sentiments}}
data frame, and others call the relevant function in the \pkg{textdata}
package.
}
\examples{

library(dplyr)

get_sentiments("bing")

\dontrun{
get_sentiments("afinn")
get_sentiments("nrc")
}

}
