% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{get_stop_frequency}
\alias{get_stop_frequency}
\title{Get Stop Frequency}
\usage{
get_stop_frequency(
  gtfs_obj,
  start_hour = 6,
  end_hour = 22,
  service_ids = NULL,
  by_route = FALSE
)
}
\arguments{
\item{gtfs_obj}{a list of gtfs dataframes as read by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{start_hour}{(optional) an integer indicating the start hour (default 6)}

\item{end_hour}{(optional) an integer indicating the end hour (default 22)}

\item{service_ids}{(optional) a set of service_ids from the calendar dataframe
identifying a particular service id. If not provided the service_id
with the most departures is used}

\item{by_route}{default TRUE, if FALSE then calculate headway for any line coming through the stop in the same direction on the same schedule.}
}
\value{
dataframe of stops with the number of departures and the headway
(departures divided by timespan) as columns.
}
\description{
Note that some GTFS feeds contain a frequency data frame already.
Consider using this instead, as it will be more accurate than what
tidytransit calculates.
}
\examples{
data(gtfs_duke)
stop_frequency <- get_stop_frequency(gtfs_duke)
x <- order(stop_frequency$mean_headway)
head(stop_frequency[x,])
}
