% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ozonate_bromate.R
\name{ozonate_bromate_once}
\alias{ozonate_bromate_once}
\title{Apply `ozonate_bromate`function within a data frame and output a data frame}
\usage{
ozonate_bromate_once(
  df,
  input_water = "defined_water",
  dose = 0,
  time = 0,
  model = "Ozekin"
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using
\code{\link{define_water_once}}. The df may include a column named for the applied chlorine dose (cl2),
and a column for time in minutes.}

\item{input_water}{name of the column of water class data to be used as the input for this function. Default is "defined_water".}

\item{dose}{Applied ozone dose (mg/L as O3). Results typically valid for 1-10 mg/L, but varies depending on model.}

\item{time}{Reaction time (minutes). Results typically valid for 1-120 minutes, but varies depending on model.}

\item{model}{Model to apply, defaults to "Ozekin". One of c("Ozekin", "Sohn", "Song", "Galey", "Siddiqui")}
}
\value{
A data frame with updated bromate.
}
\description{
This function allows \code{\link{ozonate_bromate}} to be added to a piped data frame.
Its output is a data frame containing a bro3 column.
}
\details{
The data input comes from a `water` class column, as initialized in \code{\link{define_water_chain}}.

If the input data frame has a dose column (dose) or time column (time), the function will use those columns. Note:
The function can only take dose and time inputs as EITHER a column or as function arguments, not both.

tidywater functions cannot be added after this function because they require a `water` class input.

For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
for the option to use parallel processing and speed things up. To initialize parallel processing, use
`plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
`fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain("raw") \%>\%
  ozonate_bromate_once(input_water = "raw", dose = 3, time = 8)

example_df <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain("raw") \%>\%
  mutate(
    dose = c(seq(.5, 3, .5), seq(.5, 3, .5)),
    time = 10
  ) \%>\%
  ozonate_bromate_once(input_water = "raw")

example_df <- water_df \%>\%
  mutate(br = 80) \%>\%
  define_water_chain("raw") \%>\%
  mutate(time = 8) \%>\%
  ozonate_bromate_once(
    input_water = "raw", dose = 6, model = "Sohn"
  )
\donttest{
# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain() \%>\%
  ozonate_bromate_once(input_water = "defined_water", dose = 4, time = 8)

# Optional: explicitly close multisession processing
plan(sequential)
}

}
\seealso{
\code{\link{ozonate_bromate}}
}
