% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvect_chlorine.R
\name{solvect_chlorine}
\alias{solvect_chlorine}
\title{Determine disinfection credit from chlorine.}
\source{
Smith et al. (1995)

USEPA (2020)

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
solvect_chlorine(water, time, residual, baffle)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}. Water must include ph and temp}

\item{time}{Retention time of disinfection segment in minutes.}

\item{residual}{Minimum chlorine residual in disinfection segment in mg/L as Cl2.}

\item{baffle}{Baffle factor - unitless value between 0 and 1.}
}
\value{
A data frame of the required CT, actual CT, and giardia log removal.
}
\description{
This function takes a water defined by \code{\link{define_water}} and other disinfection parameters
and outputs a data frame of the required CT (`ct_required`), actual CT (`ct_actual`), and giardia log removal (`glog_removal`).
}
\details{
CT actual is a function of time, chlorine residual, and baffle factor, whereas CT required is a function of
pH, temperature, chlorine residual, and the standard 0.5 log removal of giardia requirement.  CT required is an
empirical regression equation developed by Smith et al. (1995) to provide conservative estimates for CT tables
in USEPA Disinfection Profiling Guidance.
Log removal is a rearrangement of the CT equations.
}
\examples{

example_ct <- define_water(ph = 7.5, temp = 25) \%>\%
  solvect_chlorine(time = 30, residual = 1, baffle = 0.7)
}
\seealso{
\code{\link{define_water}}
}
