% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_property_with_details.R
\name{tw_get_property_with_details}
\alias{tw_get_property_with_details}
\title{Gets all details of a property}
\usage{
tw_get_property_with_details(id, p, wait = 0)
}
\arguments{
\item{id}{A characther vector, must start with Q, e.g. "Q254" for Wolfgang Amadeus Mozart.}

\item{p}{A character vector, a property. Must always start with the capital letter "P", e.g. "P31" for "instance of".}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}
}
\value{
A tibble, corresponding to the details for the given property. NULL if no relevant property found.
}
\description{
Gets all details of a property
}
\examples{
# Get "female form of label", including language
tw_get_property_with_details(id = "Q64733534", p = "P2521")
}
