% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transportation.R
\name{roads}
\alias{roads}
\title{Download a roads shapefile into R}
\usage{
roads(state, county, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like
to download the roads for. Can also be state name or abbreviation
(case-insensitive).}

\item{county}{The three-digit FIPS code of the county you'd like the roads for.
Can also be a county name.}

\item{year}{the data year (defaults to 2019).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
From the Census Bureau: "The content of the all roads shapefile includes
primary roads, secondary roads, local neighborhood roads,
rural roads, city streets, vehicular trails (4WD), ramps, service drives,
walkways, stairways, alleys, and private roads."
}
\examples{
\dontrun{
library(tigris)
library(ggplot2)
library(ggthemes)

roads <- roads("Maine", "031")

gg <- ggplot()
gg <- gg + geom_sf(data = roads,
                   color="black", fill="white", size=0.25)
gg <- gg + theme_map()
gg
}
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2019/TGRSHP2019_TechDoc.pdf}

Other transportation functions: 
\code{\link{address_ranges}()},
\code{\link{primary_roads}()},
\code{\link{primary_secondary_roads}()},
\code{\link{rails}()}
}
\concept{transportation functions}
