% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly5_di.R
\name{poly5_di}
\alias{poly5_di}
\title{Estimate the diameter at a given height based on a 5th degree polynomial function.}
\usage{
poly5_di(dbh, h, hi, coef)
}
\arguments{
\item{dbh}{tree diameter at breast height, in centimeters.}

\item{h}{total tree height, in meters.}

\item{hi}{height at which the diameter will be calculated, in meters.}

\item{coef}{numerical vector containing six coefficients of the 5th degree polynomial function that describes the tree's taper.}
}
\value{
a numeric value indicating the diameter at the given height.
}
\description{
Estimates the diameter at a given height of a tree from the diameter at breast height, total height and the coefficients of the 5th degree polynomial function that describes the tree's taper.
}
\examples{

library(dplyr)
library(minpack.lm)
library(timbeR)

tree_scaling <- tree_scaling \%>\%
mutate(did = di/dbh,
       hih = hi/h)

poli5 <- lm(did~hih+I(hih^2)+I(hih^3)+I(hih^4)+I(hih^5),tree_scaling)

coef_poli <- coef(poli5)

dbh <- 25
h <- 20
di <- 5

poly5_di(dbh, h, di, coef_poli)

}
