% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randsplit.R
\name{randsplit}
\alias{randsplit}
\title{Draw indices for a random split of a vector into intervals of the same mean length}
\usage{
randsplit(
  n.grid,
  n.interval,
  method = c("modunif", "random", "weighted"),
  weights = numeric(0),
  offset = 0,
  min.internal = 2
)
}
\arguments{
\item{n.grid}{number of grid points to divide into intervals}

\item{n.interval}{number of intervals}

\item{method}{method for random splitting:\cr
\code{modunif}  modification of uniform intervals\cr
\code{random}   random split (higher variability in inverval lengths)\cr
\code{weighted} random split with weights; 
    non-normalized weights must be specified by the argument \code{weights}\cr}

\item{weights}{weights for choosing interval boundaries for method \code{weighted}; 
vector of length i2-i1+1 (does not need to be normalized and will be
ignored for all methods except for method \code{weighted})}

\item{offset}{offset to shift subset of potential interval boundaries to draw from.
To guarantee different intervals on subsequent calls, offset should be
increased by one between subsequent calls for the same variable.}

\item{min.internal}{minimum number of internal points between interval boundary points}
}
\value{
the function returns an index vector of length n+1 with the endpoint indices of
        the random intervals.
}
\description{
This function draws indices for a random split of a vector into sub-vectors.
}
\examples{
randsplit(100,10)
randsplit(100,10)
randsplit(100,10,method="random")
randsplit(100,10,method="weighted",weights=1:100)
for ( i in 1:10 ) print(randsplit(100,10,method="weighted",weights=1:100,offset=i))
}
