% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_diff.R
\name{time_diff}
\alias{time_diff}
\title{Calculate time difference}
\usage{
time_diff(
  x,
  y,
  time_by = 1,
  time_type = getOption("timeplyr.time_type", "auto")
)
}
\arguments{
\item{x}{Start date or datetime.}

\item{y}{End date or datetime.}

\item{time_by}{Must be one of the three (Default is 1):
\itemize{
\item string, specifying either the unit or the number and unit, e.g
\code{time_by = "days"} or \code{time_by = "2 weeks"}
\item named list of length one, the unit being the name, and
the number the value of the list, e.g. \code{list("days" = 7)}.
For the vectorized time functions, you can supply multiple values,
e.g. \code{list("days" = 1:10)}.
\item Numeric vector. If time_by is a numeric vector and x is not a date/datetime,
then arithmetic is used, e.g \code{time_by = 1}.
}}

\item{time_type}{Time difference type: "auto", "duration" or "period".}
}
\value{
A numeric vector recycled to the length of \code{max(length(x), length(y))}.
}
\description{
This is a neat wrapper around lubridate's
date/datetime arithmetic with support for numeric values and
any class that supports arithmetic through "base::\code{-}"
If either x or y are date/datetimes and time_type is "duration" or "period",
then lubridate arithmetic is used, otherwise base R arithmetic is used.

Some more exotic time units such as quarters, fortnights, etc
can be specified.
}
\examples{
library(timeplyr)
library(lubridate)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
time_diff(today(), today() + days(10),
          time_by = "days")
time_diff(today(), today() + days((0:3) * 7),
          time_by = weeks(1))
time_diff(today(), today() + days(100),
          time_by = list("days" = 1:100))
time_diff(1, 1 + 0:100, time_by = 3)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
