% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_aggregate.R
\name{time_aggregate}
\alias{time_aggregate}
\title{Aggregate time to a higher unit}
\usage{
time_aggregate(
  x,
  time_by = NULL,
  from = NULL,
  to = NULL,
  time_type = getOption("timeplyr.time_type", "auto"),
  roll_month = getOption("timeplyr.roll_month", "preday"),
  roll_dst = getOption("timeplyr.roll_dst", "boundary"),
  time_floor = FALSE,
  week_start = getOption("lubridate.week.start", 1),
  as_interval = getOption("timeplyr.use_intervals", FALSE)
)
}
\arguments{
\item{x}{Time vector. \cr
Can be a \code{Date}, \code{POSIXt}, \code{numeric}, \code{integer},
\code{yearmon}, or \code{yearqtr} vector.}

\item{time_by}{Time unit. \cr
Must be one of the following:
\itemize{
\item string, e.g \code{time_by = "day"} or \code{time_by = "2 weeks"}
\item lubridate duration or period object, e.g. \code{days(1)} or \code{ddays(1)}.
\item named list of length one, e.g. \code{list("days" = 7)}.
\item Numeric vector, e.g. \code{time_by = 7}.
}}

\item{from}{Start.}

\item{to}{End.}

\item{time_type}{If "auto", \code{periods} are used for
the time expansion when days, weeks, months or years are specified,
and \code{durations} are used otherwise.}

\item{roll_month}{Control how impossible dates are handled when
month or year arithmetic is involved.}

\item{roll_dst}{See \code{?timechange::time_add} for the full list of details.}

\item{time_floor}{Should \code{from} be floored to the nearest unit specified
through the \code{time_by} argument?
This is particularly useful for starting sequences at the
beginning of a week or month for example.}

\item{week_start}{day on which week starts following ISO conventions - 1
means Monday (default), 7 means Sunday.
This is only used when \code{time_floor = TRUE}.}

\item{as_interval}{Should result be a \code{time_interval}?
Default is \code{TRUE}. \cr
This can be controlled globally through \code{options(timeplyr.use_intervals)}.}
}
\value{
A \code{time_interval}.
}
\description{
Aggregate time to a higher unit for possibly many groups
with respect to a time index.
}
\details{
\code{time_aggregate} aggregates time using
distinct moving time range blocks of a specified time unit.

The actual calculation is extremely simple and essentially requires
a subtraction, a rounding and an addition.

To perform a by-group time aggregation, simply supply
\code{collapse::fmin(x, g = groups, TRA = "replace_fill")} as the
\code{from} argument.
}
\examples{
library(timeplyr)
library(nycflights13)
library(lubridate)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
sunique <- function(x) sort(unique(x))

hours <- sunique(flights$time_hour)
days <- as_date(hours)

# Aggregate by week or any time unit easily
sunique(time_aggregate(hours, "week"))
sunique(time_aggregate(hours, ddays(14)))
sunique(time_aggregate(hours, "month"))
sunique(time_aggregate(days, "month"))

# Left aligned
sunique(time_aggregate(days, "quarter"))

# Very fast by group aggregation
start <- collapse::fmin(flights$time_hour, g = flights$tailnum,
                        TRA = "replace_fill")
week_by_tailnum <- time_aggregate(flights$time_hour, time_by = ddays(7),
                                  from = start)
# Confirm this has been done by group as each group will have a
# Different aggregate start date
flights \%>\%
  stat_summarise(week_by_tailnum, .by = tailnum, stat = "min",
                 sort = FALSE)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
\seealso{
\link{time_summarisev} \link{time_cut}
}
